using System;
using System.Collections;
using System.ComponentModel;
using System.ComponentModel.Design;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;

namespace gov.va.med.vbecs.GUI.controls
{


	#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary>
		///Blood Unit List control. Used to display select blood units in a list view
		///</summary>

		#endregion

	
	
	public class BloodUnitList : GUI.controls.BaseControl 
	{

		#region Variables

		private string _SortOrder = "";
		private string _caption = "";
		private bool _checkBoxes = true;
		private System.Data.DataTable dtBloodUnits;
		
		#endregion

		#region Events

		private System.EventHandler onBloodUnitSelected;
		private System.EventHandler onBloodUnitDeselected;
		private System.EventHandler onCaptionChanged;
		private System.EventHandler onCheckBoxesChanged;
		private System.EventHandler onEmptyList;
		private System.EventHandler onUnitsInList;
		
		#endregion

		#region Controls

		private BloodUnitSelector _unitSelector;		
		private System.Windows.Forms.GroupBox grpSelectedUnits;
		private System.Windows.Forms.Panel pnlRight;
		private System.Windows.Forms.ColumnHeader colCheckBox;
		private System.Windows.Forms.ColumnHeader colUnitID;
		private System.Windows.Forms.ColumnHeader colProduct;
		private System.Windows.Forms.ColumnHeader colDonation;
		private System.Windows.Forms.ColumnHeader colABORh;
		private System.Windows.Forms.ColumnHeader colExpire;
		private System.Windows.Forms.ColumnHeader colStatus;
		private System.Windows.Forms.ColumnHeader colDateTimeReceived;
		private System.Windows.Forms.ListView lvSelectedUnitsCheckboxes;
		private System.Windows.Forms.ListView lvSelectedUnitsNoCheckboxes;
		private System.Windows.Forms.ColumnHeader colLUnitID;
		private System.Windows.Forms.ColumnHeader colLProduct;
		private System.Windows.Forms.ColumnHeader colLDonation;
		private System.Windows.Forms.ColumnHeader colLABORh;
		private System.Windows.Forms.ColumnHeader colLExpires;
		private System.Windows.Forms.ColumnHeader colLStatus;
		private System.Windows.Forms.ColumnHeader colLDateIn;
		/// <summary> 
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		#endregion

		#region Constructors/Destructors
		///<Developers>
		///	<Developer>Carrie Van Stedum</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/31/2002</CreationDate>
		/// <summary>
		/// BloodUnitList class constructor. Creates the instance of the control.
		/// </summary>
		public BloodUnitList()
		{
			InitializeComponent();			
		}

		
		///<Developers>
		///	<Developer>Carrie Van Stedum</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/31/2002</CreationDate>
		/// <summary>
		/// BloodUnitList class constructor. Creates the instance of the control and
		/// fills values for the properties.
		/// </summary>
		/// <param name="unitSelector">BloodUnitSelector</param>
		public BloodUnitList(BloodUnitSelector unitSelector)
		{
			InitializeComponent();
			//
			_unitSelector = unitSelector;
			dtBloodUnits = new DataTable("BloodUnits");
			//
			dtBloodUnits.Columns.Add("Unit ID");
			dtBloodUnits.Columns.Add("Product");
			dtBloodUnits.Columns.Add("ABORh");
			dtBloodUnits.Columns.Add("Expires");
			dtBloodUnits.Columns.Add("Donation");
			dtBloodUnits.Columns.Add("Status");
			dtBloodUnits.Columns.Add("Date In");
			_unitSelector.SelectBtnClick += new BloodUnitSelector.SelectBtnClickedEventHandler(HandleSelectClick);		
		}


		/// <summary> 
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}
		#endregion

		#region Component Designer generated code
		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.grpSelectedUnits = new System.Windows.Forms.GroupBox();
			this.pnlRight = new System.Windows.Forms.Panel();
			this.lvSelectedUnitsCheckboxes = new System.Windows.Forms.ListView();
			this.colCheckBox = new System.Windows.Forms.ColumnHeader();
			this.colUnitID = new System.Windows.Forms.ColumnHeader();
			this.colProduct = new System.Windows.Forms.ColumnHeader();
			this.colABORh = new System.Windows.Forms.ColumnHeader();
			this.colExpire = new System.Windows.Forms.ColumnHeader();
			this.colDonation = new System.Windows.Forms.ColumnHeader();
			this.colStatus = new System.Windows.Forms.ColumnHeader();
			this.colDateTimeReceived = new System.Windows.Forms.ColumnHeader();
			this.lvSelectedUnitsNoCheckboxes = new System.Windows.Forms.ListView();
			this.colLUnitID = new System.Windows.Forms.ColumnHeader();
			this.colLProduct = new System.Windows.Forms.ColumnHeader();
			this.colLABORh = new System.Windows.Forms.ColumnHeader();
			this.colLExpires = new System.Windows.Forms.ColumnHeader();
			this.colLDonation = new System.Windows.Forms.ColumnHeader();
			this.colLStatus = new System.Windows.Forms.ColumnHeader();
			this.colLDateIn = new System.Windows.Forms.ColumnHeader();
			this.SuspendLayout();
			// 
			// grpSelectedUnits
			// 
			this.grpSelectedUnits.Location = new System.Drawing.Point(0, 0);
			this.grpSelectedUnits.Name = "grpSelectedUnits";
			this.grpSelectedUnits.TabIndex = 0;
			this.grpSelectedUnits.TabStop = false;
			// 
			// pnlRight
			// 
			this.pnlRight.Location = new System.Drawing.Point(0, 0);
			this.pnlRight.Name = "pnlRight";
			this.pnlRight.TabIndex = 0;
			// 
			// lvSelectedUnitsCheckboxes
			// 
			this.lvSelectedUnitsCheckboxes.AccessibleDescription = "Selected Units";
			this.lvSelectedUnitsCheckboxes.AccessibleName = "Selected Units";
			this.lvSelectedUnitsCheckboxes.FullRowSelect = true;
			this.lvSelectedUnitsCheckboxes.HideSelection = false;
			this.lvSelectedUnitsCheckboxes.Location = new System.Drawing.Point(0, 0);
			this.lvSelectedUnitsCheckboxes.Name = "lvSelectedUnitsCheckboxes";
			this.lvSelectedUnitsCheckboxes.TabIndex = 0;
			this.lvSelectedUnitsCheckboxes.SelectedIndexChanged += new System.EventHandler(this.lvSelectedUnitsCheckboxes_SelectedIndexChanged);
			// 
			// lvSelectedUnitsNoCheckboxes
			// 
			this.lvSelectedUnitsNoCheckboxes.AccessibleDescription = "Selected Units";
			this.lvSelectedUnitsNoCheckboxes.AccessibleName = "Selected Units";
			this.lvSelectedUnitsNoCheckboxes.FullRowSelect = true;
			this.lvSelectedUnitsNoCheckboxes.HideSelection = false;
			this.lvSelectedUnitsNoCheckboxes.Location = new System.Drawing.Point(0, 0);
			this.lvSelectedUnitsNoCheckboxes.Name = "lvSelectedUnitsNoCheckboxes";
			this.lvSelectedUnitsNoCheckboxes.TabIndex = 0;
			// 
			// BloodUnitList
			// 
			this.Controls.Add(this.grpSelectedUnits);
			this.Name = "BloodUnitList";
			this.Size = new System.Drawing.Size(528, 164);
			this.ResumeLayout(false);

		}
		#endregion

		#region Properties

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary>
		/// Gets or sets caption to display above unit list. Editable at design time
		/// </summary>
		[
		Category("Appearance"),
		Description("The caption for the control"),
		DefaultValue("Selected Units"),
		Bindable(false),
		Browsable(true),
		]
		public string Caption 
		{
			get 
			{ 
				return _caption; 
			}
			set 
			{
				_caption = value;
				if (onCaptionChanged != null)
				{
					onCaptionChanged(null,EventArgs.Empty);
				}
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary>
		/// Gets or sets value to determine if checkboxes should be displayed. Editable at design time
		/// </summary>
		[
		Category("Appearance"),
		Description("Indicates whether checkboxes are displayed next to items"),
		DefaultValue("false"),
		Bindable(false),
		Browsable(true),
		]
		public bool CheckBoxes 
		{
			get 
			{ 
				return _checkBoxes;
			}
			set 
			{
				_checkBoxes = value;
				lvSelectedUnitsCheckboxes.Visible = _checkBoxes;
				lvSelectedUnitsNoCheckboxes.Visible = !_checkBoxes;
				if (onCheckBoxesChanged!=null) onCheckBoxesChanged(null,EventArgs.Empty);
			}
		}


		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary>
		/// Gets or sets docking style property
		/// </summary>
		[
		Category("Layout"),
		Description("Docking style"),
		Bindable(false),
		Browsable(true),
		]
		public override DockStyle Dock 
		{
			get 
			{ 
				return base.Dock;
			}
			set 
			{ 
				base.Dock = value;
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary>
		/// Gets or sets anchor style property
		/// </summary>
		[
		Category("Layout"),
		Description("Anchor style"),
		Bindable(false),
		Browsable(true),
		]
		public override AnchorStyles Anchor
		{
			get 
			{ 
				return base.Anchor;
			}
			set 
			{ 
				base.Anchor = value;
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary>
		/// Gets sort order of units in list
		/// </summary>
		public string SortOrder
		{
			get	
			{
				return this._SortOrder;
			}
		}

	
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary> 
		/// Gets table of units that were selected
		/// </summary>
		public System.Data.DataTable BloodUnits
		{
			get
			{
				return dtBloodUnits;
			}
		}
		
		
		///<Developers>
		///	<Developer>Carrie Van Stedum</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/31/2002</CreationDate>
		/// <summary>
		/// SelectedBloodUnits
		/// </summary>
		public System.Data.DataTable SelectedBloodUnits
		{
			get
			{
				System.Data.DataTable dtSelectedBloodUnits;
				dtSelectedBloodUnits = dtBloodUnits.Clone();

				foreach(ListViewItem lvItem in this.lvSelectedUnitsNoCheckboxes.SelectedItems)
				{
					BOL.BloodUnit _currentBloodBag = (BOL.BloodUnit)lvItem.Tag;
					System.Data.DataRow dtReturnedRow = dtSelectedBloodUnits.NewRow();
					System.Data.DataRow[] dtRow = dtBloodUnits.Select("Unit ID = " + _currentBloodBag.LabelUnitId);
					dtReturnedRow.ItemArray = dtRow[0].ItemArray;
					dtSelectedBloodUnits.Rows.Add(dtReturnedRow);
				}
				return dtSelectedBloodUnits;
			}
		}

		#endregion

		#region Methods
		
		
		///<Developers>
		///	<Developer>Carrie Van Stedum</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/31/2002</CreationDate>
		/// <summary>
		/// Public method to populate list view with a given blood unit. Checks if the unit
		/// has already been the part of the listview. If not the unit is being added 
		/// to the view.
		/// </summary>
		/// <param name="bloodUnit">Blood unit</param>
		public void PopulateGrid(BOL.BloodUnit bloodUnit)
		{
			this.OnUserActivity();

			foreach (ListViewItem lviUnit in this.lvSelectedUnitsCheckboxes.Items)
			{
				BOL.BloodUnit testUnit = (BOL.BloodUnit)lviUnit.Tag;
				//
				if ((testUnit.EyeReadableUnitId.Equals(bloodUnit.EyeReadableUnitId)) && (testUnit.ProductCode.Equals(bloodUnit.ProductCode)))
				{
					if (!lviUnit.Checked)
					{
						lviUnit.Checked = true;
					}
					else
					{
						MessageBox.Show(Common.StrRes.ValidMsg.Common.BloodUnitList(bloodUnit.EyeReadableUnitId).ResString,"VBECS - Information",MessageBoxButtons.OK,MessageBoxIcon.Asterisk);
					}
					return;
				}
			}
			//
			ListViewItem lviCheckBoxBloodUnit  = new ListViewItem();
			//
			lviCheckBoxBloodUnit.Checked = true;
			lviCheckBoxBloodUnit.Text = "";
			lviCheckBoxBloodUnit.Tag = bloodUnit;
			//
			lviCheckBoxBloodUnit.SubItems.Add(bloodUnit.EyeReadableUnitId);
			lviCheckBoxBloodUnit.SubItems.Add(bloodUnit.ProductName);
			lviCheckBoxBloodUnit.SubItems.Add(bloodUnit.BloodUnitMedia.AboRh.AboRHText);
			lviCheckBoxBloodUnit.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(bloodUnit.BloodUnitMedia.UnitExpirationDate));
			lviCheckBoxBloodUnit.SubItems.Add(bloodUnit.DonationType.DonationTypeText);
			lviCheckBoxBloodUnit.SubItems.Add(bloodUnit.BloodUnitStatus.UnitStatusText);
			lviCheckBoxBloodUnit.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(bloodUnit.IncomingShipment.ShipmentDate));
			//
			lvSelectedUnitsCheckboxes.Items.Add(lviCheckBoxBloodUnit);
			//
			ListViewItem lviNoCheckBoxBloodUnit = new ListViewItem(bloodUnit.EyeReadableUnitId);
			lviNoCheckBoxBloodUnit.SubItems.Add(bloodUnit.ProductName);
			lviNoCheckBoxBloodUnit.SubItems.Add(bloodUnit.BloodUnitMedia.AboRh.AboRHText);
			lviNoCheckBoxBloodUnit.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(bloodUnit.BloodUnitMedia.UnitExpirationDate));
			lviNoCheckBoxBloodUnit.SubItems.Add(bloodUnit.DonationType.DonationTypeText);
			lviNoCheckBoxBloodUnit.SubItems.Add(bloodUnit.BloodUnitStatus.UnitStatusText);
			lviNoCheckBoxBloodUnit.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(bloodUnit.IncomingShipment.ShipmentDate));
			lviNoCheckBoxBloodUnit.Tag = bloodUnit;
			//
			lvSelectedUnitsNoCheckboxes.Items.Add(lviNoCheckBoxBloodUnit);
			if (_checkBoxes)
			{
				if (onUnitsInList!=null) onUnitsInList(null,EventArgs.Empty);
			}
			//
			controls.VbecsFunction.SetColumnWidths(lvSelectedUnitsCheckboxes);
			controls.VbecsFunction.SetColumnWidths(lvSelectedUnitsNoCheckboxes);
		}

		
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary>
		/// Public method to clear all units from the list.
		/// </summary>
		public void ClearAllUnits()
		{
			this.OnUserActivity();

			lvSelectedUnitsCheckboxes.Items.Clear();
			lvSelectedUnitsNoCheckboxes.Items.Clear();
			if (_checkBoxes)
			{
				if (onEmptyList!=null) onEmptyList(null,EventArgs.Empty);
			}
		}
		#endregion

		#region Event handlers
		///<Developers>
		///	<Developer>Carrie Van Stedum</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/31/2002</CreationDate>
		/// <summary>
		/// Caption changed event handler 
		/// </summary>
		public event EventHandler CaptionChanged
		{
			add 
			{ 
				onCaptionChanged += value;
			}
			remove 
			{ 
				onCaptionChanged -= value;
			}
		}

		
		///<Developers>
		///	<Developer>Carrie Van Stedum</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/31/2002</CreationDate>
		/// <summary>
		/// Checkboxes changed event handler
		/// </summary>
		public event EventHandler CheckBoxesChanged
		{
			add 
			{ 
				onCheckBoxesChanged += value; 
			}
			remove 
			{ 
				onCheckBoxesChanged -= value;
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary> 
		/// Event Handler, raised when a blood unit has been selected
		/// </summary>
		public event EventHandler BloodUnitSelected
		{
			add
			{ 
				onBloodUnitSelected += value;
			}
			remove 
			{ 
				onBloodUnitSelected -= value;
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary>
		/// Event Handler, raised when no blood unit is selected
		/// </summary>
		public event EventHandler BloodUnitDeselected
		{
			add 
			{ 
				onBloodUnitDeselected += value;
			}
			remove 
			{ 
				onBloodUnitDeselected -= value;
			}
		}

		
		///<Developers>
		///	<Developer>Carrie Van Stedum</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/31/2002</CreationDate>
		/// <summary>
		/// Empty list event handler
		/// </summary>
		public event EventHandler EmptyList
		{
			add 
			{ 
				onEmptyList += value;
			}
			remove 
			{
				onEmptyList -= value;
			}
		}

		
		///<Developers>
		///	<Developer>Carrie Van Stedum</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/31/2002</CreationDate>
		/// <summary>
		/// Units in list event handler
		/// </summary>
		public event EventHandler UnitsInList
		{
			add 
			{ 
				onUnitsInList += value;
			}
			remove 
			{
				onUnitsInList -= value;
			}
		}

		#endregion

		#region Events

		///<Developers>
		///	<Developer>Carrie Van Stedum</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/31/2002</CreationDate>
		/// <summary>
		/// Blood Unit Selector SelectBtnClick event handler
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void HandleSelectClick(object sender, EventArgs e) 
		{
			this.OnUserActivity();

			BOL.BloodUnit _bloodUnit = _unitSelector.BloodUnit;
			//
			System.Data.DataRow dtRow =  dtBloodUnits.NewRow();
			object [] _rowValues =
			{
				_bloodUnit.LabelUnitId,
				_bloodUnit.ProductName,
				_bloodUnit.BloodUnitMedia.AboRh.Abo + "/" + _bloodUnit.BloodUnitMedia.AboRh.RH,
				_bloodUnit.BloodUnitMedia.UnitExpirationDate,
				_bloodUnit.DonationType.DonationTypeText,
				_bloodUnit.BloodUnitStatus.UnitStatusText,
				_bloodUnit.UnitInDate
			};

			//
			dtBloodUnits.Rows.Add(_rowValues);
			PopulateGrid(_bloodUnit);
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary>
		/// Private method to sort unit list based on column header clicker
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void lvSelectedUnits_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			this.OnUserActivity();

			lvSelectedUnitsCheckboxes.ListViewItemSorter = new SortBySubItem(e.Column);
			lvSelectedUnitsNoCheckboxes.ListViewItemSorter = new SortBySubItem(e.Column);
			_SortOrder = lvSelectedUnitsCheckboxes.Columns[e.Column].Text.Trim();
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary>
		/// Protected method to update display when captions changes
		/// </summary>
		/// <param name="e">Event args</param>
		protected virtual void OnCaptionChanged(System.EventArgs e)
		{
			grpSelectedUnits.Text = this._caption;
			grpSelectedUnits.Refresh();
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary>
		/// Check boxes changed
		/// </summary>
		/// <param name="e">Event args</param>
		protected virtual void OnCheckBoxesChanged(System.EventArgs e)
		{

		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary>
		/// Blood unit selected
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		protected virtual void OnBloodUnitSelected(object sender, System.EventArgs e)
		{
			//
			
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary>
		/// Blood unit deselected
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		protected virtual void OnBloodUnitDeselected(object sender, System.EventArgs e)
		{
			//
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary>
		/// Empty list
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		protected virtual void OnEmptyList(object sender, System.EventArgs e)
		{
			//
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary>
		/// Units in list
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		protected virtual void OnUnitsInList(object sender, System.EventArgs e)
		{
			//
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary>
		/// Raises blood unit selected or deselected event, as appropriate
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void lvSelectedUnits_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			this.OnUserActivity();

			if (!_checkBoxes)
			{
				if (this.lvSelectedUnitsNoCheckboxes.SelectedItems.Count > 0)
				{
					if (onBloodUnitSelected!=null) onBloodUnitSelected(sender,e);
				}
				else
				{
					if (onBloodUnitDeselected!=null) onBloodUnitDeselected(sender,e);
				}
			}
			else
			{
				this.SpeakListViewWithCheckBox(lvSelectedUnitsCheckboxes);
			}
		}
		#endregion

		private void lvSelectedUnitsCheckboxes_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			//508 Compliance
			this.SpeakListViewWithCheckBox(lvSelectedUnitsCheckboxes);
			if (lvSelectedUnitsCheckboxes.SelectedIndices.Count > 0 && Common.LogonUser.IsVisuallyImpairedUser)
			{
				using (new WaitCursor())
				{
					System.Text.StringBuilder buildUserList = new StringBuilder();
					ListViewItem lVI = ((System.Windows.Forms.ListView) lvSelectedUnitsCheckboxes).SelectedItems[0];
					string[] mySubItems = new string[lVI.SubItems.Count];
											
						
					for(int nCtr = 0; nCtr < lvSelectedUnitsCheckboxes.Columns.Count; nCtr++)
					{
						buildUserList.Append(lvSelectedUnitsCheckboxes.Columns[nCtr].Text + "coe lin ");
						buildUserList.Append("  ");
						mySubItems[nCtr] = lVI.SubItems[nCtr].Text.Trim();
						if(lVI.SubItems[nCtr].Text.Trim().Length == 0)
						{
							buildUserList.Append("");
						}
						else
						{
							buildUserList.Append(mySubItems[nCtr]);
						}
						buildUserList.Append(" ");
					}
						
					string textToSpeak =buildUserList.ToString();
						
					this.SpeakMessage( textToSpeak );	
				}		
			}
		}
	}
}